/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.ops.mgmt.command.util.RemoteExecCommand;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.storage.CommandHandler;
import oracle.ops.verification.framework.storage.FSInfo;
import oracle.ops.verification.framework.storage.LowCFSVersionException;
import oracle.ops.verification.framework.storage.NFSInfo;
import oracle.ops.verification.framework.storage.NonSharedFileSystemException;
import oracle.ops.verification.framework.storage.OCFS2Info;
import oracle.ops.verification.framework.storage.OCFSInfo;
import oracle.ops.verification.framework.storage.PathDiskInfo;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.sDisk;
import oracle.ops.verification.framework.storage.sStorageUtil;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.AccessDeniedException;
import oracle.ops.verification.util.ExecutableNotFoundException;
import oracle.ops.verification.util.GenericUtil;
import oracle.ops.verification.util.ParsingException;

class sCommandHandler
extends CommandHandler {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    static final String VXDG_LOC = "/usr/sbin/";
    static final String MOUNT_LOC = "/usr/sbin/";
    static final String IOSTAT_LOC = "/usr/bin/";
    static final String EGREP_LOC = "/usr/local/bin/";
    static final String GREP_LOC = "/usr/local/bin/";
    static final String GREP = "/bin/grep";
    static final String MTAB_LOC = "/etc/mtab";
    public static final String API_MODE_GUID = "f630615c-c0b1-498b-90a2-4e5f4bc1e599";

    sCommandHandler() {
    }

    static String makeEnglishUnixCmd(String cmd) {
        String SHELL_CMD = "/bin/sh -c ";
        String LANG_VARS = "LC_ALL=C; export LC_ALL; LANG=en;export LANG;";
        return "'/bin/sh -c \"LC_ALL=C; export LC_ALL; LANG=en;export LANG;" + cmd + "\"" + "'";
    }

    @Override
    StorageInfo parseTypeResult(VerificationCommand cmd, String path) throws StorageException {
        int exitCode = cmd.getVfyCode();
        if (18 == exitCode) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("_st_:exitcode wasn't zero:" + String.valueOf(exitCode)));
            }
            throw new NonSharedFileSystemException("7015");
        }
        if (10010 == exitCode) {
            String msg = VerificationConstants.LSEP + s_msgBundle.getMessage("7017", false);
            ExecutableNotFoundException e = new ExecutableNotFoundException(msg);
            StorageException se = new StorageException("7017", cmd.getNodeName(), null, e, true);
            throw se;
        }
        if (10013 == exitCode) {
            String msg = VerificationConstants.LSEP + s_msgBundle.getMessage("7021", false);
            AccessDeniedException e2 = new AccessDeniedException(msg);
            throw new StorageException("7021", cmd.getNodeName(), null, e2, true);
        }
        if (10019 == exitCode) {
            this.getDiskVersionErr(cmd);
        }
        if (0 != exitCode) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("_st_:exitcode wasn't zero:" + String.valueOf(exitCode)));
            }
            throw new StorageException("7009");
        }
        try {
            String storageStr = cmd.getOutput();
            int access = -1;
            String realPath = GenericUtil.getValueByKey(storageStr, "REALPATH");
            String prefName = GenericUtil.getValueByKey(storageStr, "PREFNAME");
            String typeStr = GenericUtil.getValueByKey(storageStr, "STTYPE");
            String accessStr = GenericUtil.getValueByKey(storageStr, "ACCESS");
            if (accessStr == null) {
                accessStr = "-1";
            }
            try {
                access = Integer.parseInt(accessStr);
            }
            catch (NumberFormatException nfe) {
                Trace.out((String)("Access value unknown: '" + accessStr + "'"));
                access = -1;
            }
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Adding Access: '" + access + "' for path '" + path + "'"));
            }
            int type = sStorageUtil.getTypeByStr(typeStr);
            StorageInfo stInfo = new StorageInfo(prefName, cmd.getNode(), realPath, type, path, access);
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("_st_:type is --> " + stInfo));
            }
            return stInfo;
        }
        catch (Exception e) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)"_st_:parsing gettype failed");
            }
            throw new StorageException(e);
        }
    }

    @Override
    public RemoteExecCommand genInfoCmd(String node, int type) throws StorageException {
        switch (type) {
            case 1: {
                return this.genDiskInfoCmd(node);
            }
            case 2: {
                return this.genNFSInfoCmd(node);
            }
            case 7: {
                return this.genOCFSInfoCmd(node);
            }
            case 8: {
                return this.genOCFS2InfoCmd(node);
            }
            case 5: 
            case 14: 
            case 17: {
                return null;
            }
        }
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("_st_:genInfoCmd: Can't handle " + sStorageUtil.getTypeStr(type)));
        }
        throw new StorageException();
    }

    @Override
    public RemoteExecCommand genInfoCmd(String node, int type, String path) throws StorageException {
        return this.genInfoCmd(node, type, path, null);
    }

    public RemoteExecCommand genInfoCmd(String node, int type, String path, Result result) throws StorageException {
        switch (type) {
            case 1: {
                return this.genDiskInfoCmd(node, path, result);
            }
            case 2: {
                return this.genNFSInfoCmd(node, path, result);
            }
            case 7: {
                return this.genOCFSInfoCmd(node, path, result);
            }
            case 8: {
                return this.genOCFS2InfoCmd(node, path, result);
            }
            case 5: 
            case 14: 
            case 17: {
                return this.genFSInfoCmd(node, path, result);
            }
        }
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("_st_:Don't know how to handle storage type " + sStorageUtil.getTypeStr(type)));
        }
        throw new StorageException();
    }

    @Override
    public RemoteExecCommand genInfoCmd(String node, int type, String path, String realpath, Result result) throws StorageException {
        String cmdpath = realpath != null && !path.equals(realpath) ? realpath + "%" + path : path;
        return this.genInfoCmd(node, type, cmdpath, result);
    }

    RemoteExecCommand genVXDGInfoCmd(String node) {
        String cmd = "/usr/sbin/vxprint -tqG";
        cmd = sCommandHandler.makeEnglishUnixCmd(cmd);
        String[] args = new String[]{""};
        return new RemoteExecCommand(cmd, args, null, node, null, (String)null, null);
    }

    RemoteExecCommand genVXDGInfoCmd(String node, String diskgroup) {
        String cmd = "/usr/sbin/vxprint -qtG " + diskgroup;
        cmd = sCommandHandler.makeEnglishUnixCmd(cmd);
        String[] args = new String[]{""};
        return new RemoteExecCommand(cmd, args, null, node, null, (String)null, null);
    }

    RemoteExecCommand genFSInfoCmd(String node) {
        String[] args = new String[]{"-getstinfo", "-getfsinfo"};
        return new VerificationCommand(node, args, null);
    }

    RemoteExecCommand genFSInfoCmd(String node, String path) {
        String[] args = new String[]{"-getstinfo", "-getfsinfo", path};
        return new VerificationCommand(node, args, null);
    }

    RemoteExecCommand genFSInfoCmd(String node, String path, Result result) {
        String[] args = new String[]{"-getstinfo", "-getfsinfo", path};
        return new VerificationCommand(node, args, null, result);
    }

    RemoteExecCommand genNFSInfoCmd(String node) {
        String[] args = new String[]{"-getstinfo", "-getnfsinfo"};
        return new VerificationCommand(node, args, null);
    }

    RemoteExecCommand genNFSInfoCmd(String node, String path) {
        String[] args = new String[]{"-getstinfo", "-getnfsinfo", path};
        return new VerificationCommand(node, args, null);
    }

    RemoteExecCommand genNFSInfoCmd(String node, String path, Result result) {
        String[] args = new String[]{"-getstinfo", "-getnfsinfo", path};
        return new VerificationCommand(node, args, null, result);
    }

    RemoteExecCommand genOCFSInfoCmd(String node) {
        String[] args = new String[]{"-getstinfo", "-getocfsinfo"};
        VerificationCommand vfyCmd = new VerificationCommand(node, args, null);
        return vfyCmd;
    }

    RemoteExecCommand genOCFS2InfoCmd(String node) {
        String mode = "cmdline";
        try {
            ParamManager pm = ParamManager.getInstance();
            if (pm.getMode() == ParamManager.OperationMode.MODE_API) {
                mode = "apimode";
            }
            Trace.out((String)("==== Requested mode is: " + mode));
        }
        catch (UninitializedParamManagerException e) {
            Trace.out((Exception)e);
        }
        String[] args = new String[]{"-getstinfo", "-getocfs2info", mode};
        VerificationCommand vfyCmd = new VerificationCommand(node, args, null);
        return vfyCmd;
    }

    RemoteExecCommand genOCFSInfoCmd(String node, String path) {
        String[] args = new String[]{"-getstinfo", "-getocfsinfo", path};
        return new VerificationCommand(node, args, null);
    }

    RemoteExecCommand genOCFS2InfoCmd(String node, String path) {
        String mode = "cmdline";
        try {
            ParamManager pm = ParamManager.getInstance();
            if (pm.getMode() == ParamManager.OperationMode.MODE_API) {
                mode = "apimode";
            }
            Trace.out((String)("==== Requested mode is: " + mode));
        }
        catch (UninitializedParamManagerException e) {
            Trace.out((Exception)e);
        }
        String[] args = new String[]{"-getstinfo", "-getocfs2info", mode, path};
        return new VerificationCommand(node, args, null);
    }

    RemoteExecCommand genOCFSInfoCmd(String node, String path, Result result) {
        String[] args = new String[]{"-getstinfo", "-getocfsinfo", path};
        return new VerificationCommand(node, args, null, result);
    }

    RemoteExecCommand genOCFS2InfoCmd(String node, String path, Result result) {
        String mode = "cmdline";
        try {
            ParamManager pm = ParamManager.getInstance();
            if (pm.getMode() == ParamManager.OperationMode.MODE_API) {
                mode = "apimode";
            }
            Trace.out((String)("==== Requested mode is: " + mode));
        }
        catch (UninitializedParamManagerException e) {
            Trace.out((Exception)e);
        }
        String[] args = new String[]{"-getstinfo", "-getocfs2info", mode, path};
        return new VerificationCommand(node, args, null, result);
    }

    RemoteExecCommand genDiskInfoCmd(String node) {
        String[] args = new String[]{"-getstinfo", "-getdiskinfo"};
        VerificationCommand vfyCmd = new VerificationCommand(node, args, null);
        return vfyCmd;
    }

    RemoteExecCommand genDiskInfoCmd(String node, String path) {
        String[] args = new String[]{"-getstinfo", "-getdiskinfo", path};
        VerificationCommand vfyCmd = new VerificationCommand(node, args, null);
        return vfyCmd;
    }

    RemoteExecCommand genDiskInfoCmd(String node, String path, Result result) {
        String[] args = new String[]{"-getstinfo", "-getdiskinfo", path};
        VerificationCommand vfyCmd = new VerificationCommand(node, args, null, result);
        return vfyCmd;
    }

    @Override
    public StorageInfo parseStorageInfoResult(RemoteExecCommand remCmd, String path) throws StorageException {
        StorageInfo stinfo = null;
        String node = remCmd.getNode();
        String realPath = null;
        String prefName = null;
        String typeStr = null;
        String accessStr = null;
        int access = -1;
        VerificationCommand vfyCmd = null;
        int exitCode = 0;
        vfyCmd = (VerificationCommand)remCmd;
        exitCode = vfyCmd.getVfyCode();
        String result = vfyCmd.getOutput();
        if (18 == exitCode) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("_st_:exitcode wasn't zero:" + String.valueOf(exitCode)));
            }
            throw new NonSharedFileSystemException("7015");
        }
        if (10010 == exitCode) {
            String msg = VerificationConstants.LSEP + s_msgBundle.getMessage("7017", false);
            ExecutableNotFoundException e = new ExecutableNotFoundException(msg);
            StorageException se = new StorageException("7017", vfyCmd.getNodeName(), null, e, true);
            throw se;
        }
        if (10013 == exitCode) {
            String msg = VerificationConstants.LSEP + s_msgBundle.getMessage("7021", false);
            AccessDeniedException e2 = new AccessDeniedException(msg);
            throw new StorageException("7021", vfyCmd.getNodeName(), null, e2, true);
        }
        if (10019 == exitCode) {
            this.getDiskVersionErr(vfyCmd);
        }
        if (0 != exitCode) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("_st_:exitcode wasn't zero:" + String.valueOf(exitCode)));
            }
            throw new StorageException("7009");
        }
        try {
            realPath = GenericUtil.getValueByKey(result, "REALPATH");
            prefName = GenericUtil.getValueByKey(result, "PREFNAME");
            typeStr = GenericUtil.getValueByKey(result, "STTYPE");
            accessStr = GenericUtil.getValueByKey(result, "ACCESS");
            if (accessStr == null) {
                accessStr = "-1";
            }
            try {
                access = Integer.parseInt(accessStr);
            }
            catch (NumberFormatException nfe) {
                Trace.out((String)("Access value unknown: '" + accessStr + "'"));
                access = -1;
            }
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Adding Access: '" + access + "' for path '" + path + "'"));
            }
        }
        catch (Exception e) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)"_st_:parsing gettype failed");
            }
            throw new StorageException(e);
        }
        int type = sStorageUtil.getTypeByStr(typeStr);
        stinfo = this.parseInfoResult(remCmd, type, prefName);
        if (null == stinfo) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("_st_:_st_:couldn't find " + path + " in : " + result));
            }
        } else {
            stinfo.setName(prefName);
            stinfo.setPath(realPath);
            stinfo.setAccess(access);
            stinfo.setOrigPath(path);
        }
        return stinfo;
    }

    @Override
    public Vector parseInfoResult(RemoteExecCommand remCmd, int type) throws StorageException {
        Vector retVector = new Vector();
        String[] resultLines = remCmd.getCommandResult().getResultString();
        String node = remCmd.getNode();
        if (null == resultLines) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("_st_:remoteExecCmd" + remCmd + " on node " + node + " contained no resulting strings"));
            }
            return null;
        }
        switch (type) {
            case 1: {
                this.parseDiskInfo(remCmd, node, retVector);
                break;
            }
            case 2: {
                this.parseNFSInfo(remCmd, node, retVector);
                break;
            }
            case 7: {
                this.parseOCFSInfo(remCmd, node, retVector);
                break;
            }
            case 8: {
                this.parseOCFS2Info(remCmd, node, retVector);
                break;
            }
            default: {
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)("_st_:parseInfoResult: Can't handle " + sStorageUtil.getTypeStr(type)));
                }
                throw new StorageException();
            }
        }
        return retVector;
    }

    @Override
    public StorageInfo parseInfoResult(RemoteExecCommand remCmd, int type, String path) throws StorageException {
        StorageInfo st;
        String node = remCmd.getNode();
        String[] resultLines = remCmd.getCommandResult().getResultString();
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Storage type=" + type + ", Storage path=" + path + " resultLines=" + resultLines));
        }
        if (null == resultLines) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("_st_:remExecCmd" + remCmd + " on " + node + " had no result str"));
            }
            return null;
        }
        switch (type) {
            case 1: {
                st = this.parseDiskByName(remCmd, node, path);
                break;
            }
            case 2: {
                st = this.parseNFSInfo(remCmd, node, path);
                break;
            }
            case 7: {
                st = this.parseOCFSInfo(remCmd, node, path);
                break;
            }
            case 8: {
                st = this.parseOCFS2Info(remCmd, node, path);
                break;
            }
            case 5: 
            case 14: 
            case 17: {
                st = this.parseFSInfo(remCmd, node, path, type);
                break;
            }
            default: {
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)("_st_:parseInfoResult: Can't handle " + sStorageUtil.getTypeStr(type)));
                }
                throw new StorageException();
            }
        }
        if (null == st) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("_st_:_st_:couldn't find " + path + " in lines: "));
            }
            for (int i = 0; i < resultLines.length; ++i) {
                if (!Trace.isTraceEnabled()) continue;
                Trace.out((String)("_st_:" + resultLines[i]));
            }
        }
        return st;
    }

    private void parseNFSInfo(RemoteExecCommand cmd, String node, Vector retSet) throws StorageException {
        VerificationCommand vfyCmd;
        int vfyCode;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Parsing NFSInfo command for node " + node));
        }
        if (0 == (vfyCode = (vfyCmd = (VerificationCommand)cmd).getVfyCode())) {
            Vector nfsStrings;
            String output = vfyCmd.getOutput();
            try {
                nfsStrings = GenericUtil.getAllStrByTags(output, "MOUNT");
            }
            catch (ParsingException pe) {
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)("Problem parsing the string " + output));
                    Trace.out((Exception)pe);
                }
                throw new StorageException();
            }
            for (String nfsStr : nfsStrings) {
                NFSInfo nfsInfo = this.parseNFSInfo(nfsStr, node, null);
                retSet.add(nfsInfo);
            }
        }
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("_st_:Found " + retSet.size() + " NFS mount points on " + node));
        }
    }

    private NFSInfo parseNFSInfo(RemoteExecCommand cmd, String node, String path) throws StorageException {
        VerificationCommand vfyCmd;
        int vfyCode;
        NFSInfo nfsInfo = null;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Parsing NFSInfo for path " + path));
        }
        if (0 == (vfyCode = (vfyCmd = (VerificationCommand)cmd).getVfyCode())) {
            String output = vfyCmd.getOutput();
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Successfully executed NFSInfo command. Output is:" + output));
            }
            nfsInfo = this.parseNFSInfo(output, node, path);
        } else if (Trace.isTraceEnabled()) {
            Trace.out((String)("VfyCode is " + vfyCode));
        }
        return nfsInfo;
    }

    private NFSInfo parseNFSInfo(String mntStr, String node, String path) throws StorageException {
        String fsdata;
        String pathOnServer;
        String server;
        StringBuffer mntDevBuf = new StringBuffer();
        StringBuffer mntDirBuf = new StringBuffer();
        StringBuffer mntOptsBuf = new StringBuffer();
        StringBuffer fsTypeBuf = new StringBuffer();
        this.parseMount(mntStr, mntDevBuf, mntDirBuf, mntOptsBuf, fsTypeBuf);
        String strMntDevBuf = mntDevBuf.toString();
        if (-1 != strMntDevBuf.indexOf(58)) {
            StringTokenizer stColon = new StringTokenizer(mntDevBuf.toString(), ":");
            try {
                server = stColon.nextToken();
                pathOnServer = stColon.nextToken();
            }
            catch (NoSuchElementException e) {
                Trace.out((String)("NOSUCHELEMENTEXCEPTION: " + e.getMessage()));
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)("mntStr is" + mntStr));
                    Trace.out((String)("mntDev is " + mntDevBuf));
                }
                throw new StorageException(e);
            }
        } else {
            String strMntDirBuf = mntDirBuf.toString();
            if (strMntDirBuf.indexOf("/net/") != -1) {
                int srvStart = strMntDirBuf.indexOf("/net/");
                server = strMntDirBuf.substring(srvStart += 5, strMntDirBuf.lastIndexOf(47));
                pathOnServer = strMntDirBuf.substring(strMntDirBuf.lastIndexOf(47));
            } else {
                server = new String("local");
                pathOnServer = strMntDirBuf;
            }
        }
        Trace.out((String)("server: '" + server + "' pathOnServer: '" + pathOnServer + "'"));
        try {
            fsdata = GenericUtil.getMidStrNoCase(mntStr, "FSDATA");
        }
        catch (ParsingException e) {
            throw new StorageException(e);
        }
        FSInfo fsInfo = this.parseFSInfoInternal(fsdata, node, 5);
        String mntOpts = mntOptsBuf.toString();
        NFSInfo nfsInfo = null != path ? new NFSInfo(node, path, server, pathOnServer, mntOpts, fsInfo) : new NFSInfo(node, mntDirBuf.toString(), server, pathOnServer, mntOpts, fsInfo);
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Found " + nfsInfo));
        }
        return nfsInfo;
    }

    private OCFSInfo parseOCFSInfo(RemoteExecCommand cmd, String node, String path) throws StorageException {
        Vector retSet = new Vector();
        OCFSInfo mntInfo = null;
        OCFSInfo ocfsInfo = null;
        this.parseOCFSInfo(cmd, node, retSet);
        if (retSet.size() > 0) {
            mntInfo = (OCFSInfo)retSet.firstElement();
            ocfsInfo = new OCFSInfo(node, path, mntInfo.getDevice(), mntInfo.getSignature());
        }
        return ocfsInfo;
    }

    private void parseOCFSInfo(RemoteExecCommand cmd, String node, Vector retSet) throws StorageException {
        int vfyCode = 0;
        String[] numOcfsTags = new String[]{"NUMOCFS"};
        VerificationCommand vfyCmd = (VerificationCommand)cmd;
        vfyCode = vfyCmd.getVfyCode();
        if (12 == vfyCode) {
            LowCFSVersionException se = new LowCFSVersionException("7016", node, (Object[])new String[]{node});
            throw se;
        }
        if (0 != vfyCode) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Warning: vfyCode =  " + String.valueOf(vfyCode)));
            }
            return;
        }
        String output = vfyCmd.getOutput();
        try {
            int[] numOcfs = GenericUtil.getIntFieldsByTags(output, numOcfsTags);
            if (0 == numOcfs[0]) {
                return;
            }
            Vector ocfsStrings = GenericUtil.getAllStrByTags(output, "OCFSDATA");
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("found " + ocfsStrings.size() + " ocfs volumes " + "on node " + node));
            }
            for (String ocfsStr : ocfsStrings) {
                String mntStr = GenericUtil.getMidStrNoCase(ocfsStr, "MOUNT");
                StringBuffer mntDevBuf = new StringBuffer();
                StringBuffer mntDirBuf = new StringBuffer();
                StringBuffer mntOptsBuf = new StringBuffer();
                StringBuffer fsTypeBuf = new StringBuffer();
                this.parseMount(mntStr, mntDevBuf, mntDirBuf, mntOptsBuf, fsTypeBuf);
                String guid = GenericUtil.getMidStrNoCase(ocfsStr, "OCFS_GUID");
                OCFSInfo ocfsInfo = new OCFSInfo(node, mntDirBuf.toString(), mntDevBuf.toString(), guid);
                retSet.add(ocfsInfo);
            }
        }
        catch (ParsingException pe) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Problem parsing the string " + output));
                Trace.out((Exception)pe);
            }
            throw new StorageException();
        }
    }

    private OCFS2Info parseOCFS2Info(RemoteExecCommand cmd, String node, String path) throws StorageException {
        Vector retSet = new Vector();
        OCFS2Info mntInfo = null;
        OCFS2Info ocfsInfo = null;
        this.parseOCFS2Info(cmd, node, retSet);
        if (retSet.size() > 0) {
            mntInfo = (OCFS2Info)retSet.firstElement();
            FSInfo fsi = mntInfo.getFSInfo();
            ocfsInfo = new OCFS2Info(node, path, mntInfo.getDevice(), mntInfo.getSignature());
            ocfsInfo.setFSInfo(fsi);
        }
        return ocfsInfo;
    }

    private void parseOCFS2Info(RemoteExecCommand cmd, String node, Vector retSet) throws StorageException {
        int vfyCode = 0;
        String[] numOcfsTags = new String[]{"NUMOCFS"};
        VerificationCommand vfyCmd = (VerificationCommand)cmd;
        vfyCode = vfyCmd.getVfyCode();
        if (12 == vfyCode) {
            LowCFSVersionException se = new LowCFSVersionException("7016", node, (Object[])new String[]{node});
            throw se;
        }
        if (0 != vfyCode) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Warning: vfyCode =  " + String.valueOf(vfyCode)));
            }
            if (10010 == vfyCode) {
                String msg = VerificationConstants.LSEP + s_msgBundle.getMessage("7017", false);
                ExecutableNotFoundException e = new ExecutableNotFoundException(msg);
                StorageException se = new StorageException("7017", node, null, e, true);
                throw se;
            }
            if (10013 == vfyCode) {
                String msg = VerificationConstants.LSEP + s_msgBundle.getMessage("7021", false);
                AccessDeniedException e2 = new AccessDeniedException(msg);
                throw new StorageException("7021", node, null, e2, true);
            }
            if (10019 == vfyCode) {
                this.getDiskVersionErr(vfyCmd);
            }
            return;
        }
        String output = vfyCmd.getOutput();
        try {
            int[] numOcfs = GenericUtil.getIntFieldsByTags(output, numOcfsTags);
            if (0 == numOcfs[0]) {
                return;
            }
            Vector ocfsStrings = GenericUtil.getAllStrByTags(output, "OCFSDATA");
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("found " + ocfsStrings.size() + " ocfs volumes " + "on node " + node));
            }
            for (String ocfsStr : ocfsStrings) {
                String mntStr = GenericUtil.getMidStrNoCase(ocfsStr, "MOUNT");
                StringBuffer mntDevBuf = new StringBuffer();
                StringBuffer mntDirBuf = new StringBuffer();
                StringBuffer mntOptsBuf = new StringBuffer();
                StringBuffer fsTypeBuf = new StringBuffer();
                this.parseMount(mntStr, mntDevBuf, mntDirBuf, mntOptsBuf, fsTypeBuf);
                String guid = GenericUtil.getMidStrNoCase(ocfsStr, "OCFS_GUID");
                String fsdata = GenericUtil.getMidStrNoCase(ocfsStr, "FSDATA");
                FSInfo fsInfo = this.parseFSInfoInternal(fsdata, node, 5);
                Trace.out((String)("obtained guid is=" + guid));
                if (guid.equalsIgnoreCase(API_MODE_GUID)) {
                    guid = "::" + mntDirBuf.toString() + "::" + mntDevBuf.toString() + "::" + fsInfo.getFSblocks() + "::" + fsInfo.getFSbsize();
                    Trace.out((String)("API mode guid :" + guid));
                }
                OCFS2Info ocfsInfo = new OCFS2Info(node, mntDirBuf.toString(), mntDevBuf.toString(), guid);
                ocfsInfo.setFSInfo(fsInfo);
                retSet.add(ocfsInfo);
            }
        }
        catch (ParsingException pe) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Problem parsing the string " + output));
                Trace.out((Exception)pe);
            }
            throw new StorageException(pe);
        }
    }

    private FSInfo parseFSInfo(RemoteExecCommand cmd, String node, String path, int type) throws StorageException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("parseFSInfo: Node=" + node + " , Path=" + path));
        }
        Vector retSet = new Vector();
        FSInfo fsInfo = null;
        int vfyCode = 0;
        String output = null;
        VerificationCommand vfyCmd = (VerificationCommand)cmd;
        vfyCode = vfyCmd.getVfyCode();
        if (0 == vfyCode) {
            output = vfyCmd.getOutput();
        }
        fsInfo = this.parseFSInfoInternal(output, node, type);
        return fsInfo;
    }

    private FSInfo parseFSInfoInternal(String output, String node, int type) throws StorageException {
        FSInfo fsInfo = null;
        String fsname = null;
        int fstype = 0;
        long fsbsize = 0L;
        long fsblocks = 0L;
        long fsbfree = 0L;
        long fsbavail = 0L;
        long fsfiles = 0L;
        long fsfree = 0L;
        int fsaccess = 0;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Prasing FSInfo string: " + output));
        }
        try {
            fsname = GenericUtil.getMidStrNoCase(output, "FSNAME");
            fstype = Integer.parseInt(GenericUtil.getMidStrNoCase(output, "FSTYPE"));
            fsbsize = Long.parseLong(GenericUtil.getMidStrNoCase(output, "FSBSIZE"));
            fsblocks = Long.parseLong(GenericUtil.getMidStrNoCase(output, "FSBLOCKS"));
            fsbfree = Long.parseLong(GenericUtil.getMidStrNoCase(output, "FSBFREE"));
            fsbavail = Long.parseLong(GenericUtil.getMidStrNoCase(output, "FSBAVAIL"));
            fsfiles = Long.parseLong(GenericUtil.getMidStrNoCase(output, "FSFILES"));
            fsfree = Long.parseLong(GenericUtil.getMidStrNoCase(output, "FSFREE"));
            fsaccess = Integer.parseInt(GenericUtil.getMidStrNoCase(output, "FSACCESS"));
        }
        catch (ParsingException pe) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Problem parsing the string " + output));
                Trace.out((Exception)pe);
            }
            throw new StorageException();
        }
        catch (NumberFormatException nfe) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Problem converting string to long in output: " + output));
                Trace.out((Exception)nfe);
            }
            throw new StorageException();
        }
        fsInfo = new FSInfo(node, type, fsname, fstype, fsbsize, fsblocks, fsbfree, fsbavail, fsfiles, fsfree, fsaccess);
        fsInfo.setAccess(fsaccess);
        if (Trace.isLevelEnabled((int)5)) {
            FSInfo stInfo = fsInfo;
            Trace.out((String)("\nStInfo Access: '" + stInfo.getAccess() + "' for StInfo Path '" + stInfo.getOrigPath() + "'\nFsInfo Access: '" + fsaccess + "' for FsInfo Path '" + fsname + "'"));
        }
        return fsInfo;
    }

    private void parseMount(String mntStr, StringBuffer mntDevBuf, StringBuffer mntDirBuf, StringBuffer mntOptsBuf, StringBuffer fsTypeBuf) throws StorageException {
        String mntDev = null;
        String mntDir = null;
        String mntOpts = null;
        String fsType = null;
        try {
            mntDev = GenericUtil.getMidStrNoCase(mntStr, "MNT_DEV");
            mntDir = GenericUtil.getMidStrNoCase(mntStr, "MNT_DIR");
            mntOpts = GenericUtil.getMidStrNoCase(mntStr, "MNT_OPTS");
            fsType = GenericUtil.getMidStrNoCase(mntStr, "MNT_FSTYPE");
        }
        catch (ParsingException pe) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Problem parsing the string " + mntStr));
                Trace.out((Exception)pe);
            }
            throw new StorageException();
        }
        mntDevBuf.append(mntDev);
        mntDirBuf.append(mntDir);
        mntOptsBuf.append(mntOpts);
        fsTypeBuf.append(fsType);
    }

    sDisk parseDiskByName(RemoteExecCommand cmd, String node, String name) throws StorageException {
        sDisk disk = null;
        VerificationCommand vfyCmd = (VerificationCommand)cmd;
        int vfyCode = vfyCmd.getVfyCode();
        String output = vfyCmd.getOutput();
        if (0 == vfyCode && output != null) {
            disk = this.parseDisk(output, node);
        }
        if (10010 == vfyCode) {
            String msg = VerificationConstants.LSEP + s_msgBundle.getMessage("7017", true);
            ExecutableNotFoundException e = new ExecutableNotFoundException(msg);
            throw new StorageException("7017", node, null, e, true);
        }
        if (10013 == vfyCode) {
            String msg = VerificationConstants.LSEP + s_msgBundle.getMessage("7021", true);
            AccessDeniedException e2 = new AccessDeniedException(msg);
            throw new StorageException("7021", node, null, e2, true);
        }
        if (10019 == vfyCode) {
            this.getDiskVersionErr(vfyCmd);
        }
        if ((10011 == vfyCode || output == null) && Trace.isTraceEnabled()) {
            Trace.out((String)"No disks found");
        }
        return disk;
    }

    private void parseDiskInfo(RemoteExecCommand cmd, String node, Vector retSet) throws StorageException {
        VerificationCommand vfyCmd = (VerificationCommand)cmd;
        int vfyCode = vfyCmd.getVfyCode();
        if (10010 == vfyCode) {
            String msg = VerificationConstants.LSEP + s_msgBundle.getMessage("7017", false);
            ExecutableNotFoundException e = new ExecutableNotFoundException(msg);
            StorageException se = new StorageException("7017", node, null, e, true);
            throw se;
        }
        if (10013 == vfyCode) {
            String msg = VerificationConstants.LSEP + s_msgBundle.getMessage("7021", false);
            AccessDeniedException e2 = new AccessDeniedException(msg);
            throw new StorageException("7021", node, null, e2, true);
        }
        if (10019 == vfyCode) {
            this.getDiskVersionErr(vfyCmd);
        }
        if (0 != vfyCode) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Warning: vfyCode =  " + String.valueOf(vfyCode)));
            }
            return;
        }
        String output = vfyCmd.getOutput();
        if (!output.contains("DISK")) {
            Trace.out((String)"No disks are found!", (Object[])new Object[]{5});
            return;
        }
        try {
            Vector diskStrings = GenericUtil.getAllStrByTags(output, "DISK");
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("found " + diskStrings.size() + " disks " + "on node " + node));
            }
            for (String diskStr : diskStrings) {
                sDisk diskInfo = this.parseDisk(diskStr, node);
                retSet.add(diskInfo);
            }
        }
        catch (ParsingException pe) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Problem parsing the string " + output));
                Trace.out((Exception)pe);
            }
            throw new StorageException();
        }
    }

    private sDisk parseDisk(String output, String node) throws StorageException {
        sDisk diskInfo;
        String[] diskTags = new String[]{"DISK_NAME", "DISK_SIGNATURE", "NUMPARTS", "DISK_STATE", "DISK_SIZE", "DISK_OWNER", "DISK_GROUP", "DISK_PERMISSIONS"};
        try {
            String[] diskFields = GenericUtil.getFieldsByTags(output, diskTags);
            diskInfo = new sDisk(diskFields[0], node, diskFields[1]);
            diskInfo.setSize(new StorageSize(Double.parseDouble(diskFields[4]) / 1024.0, StorageUnit.KBYTE));
            diskInfo.setNumPartitions(new Integer(diskFields[2]));
            diskInfo.setOwner(diskFields[5]);
            diskInfo.setGroup(diskFields[6]);
            diskInfo.setPermissions(diskFields[7]);
            if (Trace.isTraceEnabled()) {
                for (int j = 0; j < diskFields.length; ++j) {
                    Trace.out((String)("diskFields[" + j + "] = >" + diskFields[j] + "<"));
                }
            }
            Trace.out((String)(diskInfo + " state:" + diskFields[3] + "|as int" + String.valueOf(Integer.parseInt(diskFields[3]))));
            if (1 == Integer.parseInt(diskFields[3])) {
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)(diskInfo + " on node " + diskInfo.getNode() + " has a bad signature:" + diskInfo.getSignature()));
                }
                diskInfo.setSignatureStatus(false);
            }
        }
        catch (ParsingException pe) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Problem parsing the string " + output));
                Trace.out((Exception)pe);
            }
            throw new StorageException();
        }
        return diskInfo;
    }

    @Override
    public PathDiskInfo parseDiskDetailResult(String node, VerificationCommand vfyCmd, String path) throws StorageException {
        Trace.out((String)"Not Supported on Unix");
        return null;
    }

    private void getDiskVersionErr(VerificationCommand vfyCmd) throws StorageException {
        String error = vfyCmd.getError();
        String node = vfyCmd.getNodeName();
        Trace.out((String)("Error string: '" + error + "'"));
        String installedVersion = VerificationUtil.fetchTextByTags(error, "<SLOS_OTHERINFO>", "</SLOS_OTHERINFO>");
        Object[] args = new Object[]{"cvuqdisk", node, "1.0.9-1", installedVersion};
        String msg = VerificationConstants.LSEP + s_msgBundle.getMessage("7533", false, args);
        ExecutableNotFoundException e = new ExecutableNotFoundException(msg);
        throw new StorageException("7533", node, args, e, true);
    }
}

